// XISLReturnDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "ib.h"
#include "XISLReturnDlg.h"
#include "XISLReturnTag.h"
#include "XISLTag.h"
#include "XISLChangeVarDlg.h"
#include "XISLVar.h"
#include "XISLVarList.h"
#include "XISLExcItem.h"
#include "XISLDialogTag.h"
#include "XISLRootTag.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern CXISLRootTag *g_pAppRootTag;
/////////////////////////////////////////////////////////////////////////////
// CXISLReturnDlg _CAO


CXISLReturnDlg::CXISLReturnDlg(CXISLReturnTag *pTag,CXISLTag *pCurrentTag,CWnd* pParent /*=NULL*/)
	: CDialog(CXISLReturnDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CXISLReturnDlg)
	m_strNameList = _T("");
	m_nCount = 0;
	m_nValue = 0;
	m_strString = _T("");
	//}}AFX_DATA_INIT
	m_pRetTag = pTag;
	m_pCurrentTag = pCurrentTag;
}


void CXISLReturnDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CXISLReturnDlg)
	DDX_Control(pDX, IDC_LIST_VAR, m_lbVar);
	DDX_Control(pDX, IDC_EDIT_NAMELIST, m_editNameList);
	DDX_Text(pDX, IDC_EDIT_NAMELIST, m_strNameList);
	DDX_Text(pDX, IDC_EDIT_COUNT, m_nCount);
	DDV_MinMaxInt(pDX, m_nCount, 0, 999);
	DDX_Text(pDX, IDC_EDIT_VALUE, m_nValue);
	DDV_MinMaxInt(pDX, m_nValue, -9999999, 9999999);
	DDX_Text(pDX, IDC_EDIT_STRING, m_strString);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CXISLReturnDlg, CDialog)
	//{{AFX_MSG_MAP(CXISLReturnDlg)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_VAR, OnDblclkListVar)
	ON_BN_CLICKED(IDC_BUTTON_CHANGE, OnButtonChange)
	ON_WM_CTLCOLOR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CXISLReturnDlg bZ[W nh

void CXISLReturnDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	UpdateData();
	if(m_nCount != m_NameList.GetCount())
	{
		AfxMessageBox("߂̈ƍ܂");
		return;
	}
	POSITION pos = m_NameList.GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_NameList.GetNext(pos);
		if(pVar->IsDummy() && strcmp(pVar->GetVarName(),"*") == 0)
		{
			AfxMessageBox("w肵Ă",
				MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
			return;
		}
	}
	m_pRetTag->InitPtrList();
	pos = m_NameList.GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_NameList.GetNext(pos);
		if(!pVar->IsDummy())
			pVar->m_pParent->ReferVar(pVar->GetVarName(),TRUE);
		m_pRetTag->m_NameList.AddTail(pVar);
	}

	CDialog::OnOK();
}

void CXISLReturnDlg::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	if( m_nCount != m_pRetTag->m_NameList.GetCount() )
	{
		AfxMessageBox("߂̈ƍ܂",
				MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		return;
	}

	InitNameList();
	//ϐ̎QƉ񐔂𑝂₷
	POSITION pos = m_pRetTag->m_NameList.GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_pRetTag->m_NameList.GetNext(pos);
		if(!pVar->IsDummy())
			pVar->m_pParent->ReferVar(pVar->GetVarName(),TRUE);
	}	
	CDialog::OnCancel();
}

BOOL CXISLReturnDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	m_nCount = ((CXISLDialogTag*)m_pCurrentTag->GetParentDialogTag())->GetReCallReturnCount();
	if(m_nCount == m_pRetTag->m_NameList.GetCount())
	{
		POSITION pos = m_pRetTag->m_NameList.GetHeadPosition();
		while(pos)
		{
			CXISLVar *pVar = (CXISLVar*)m_pRetTag->m_NameList.GetNext(pos);
			if(!pVar->IsDummy())
			{
				pVar->m_pParent->ReferVar(pVar->GetVarName(),FALSE);
				m_NameList.AddTail(pVar);
			}
			else
			{
				//ϐł͂Ȃlł
				CXISLVar *pValue = new CXISLVar;
				pValue->SetAttribute(pVar->GetVarName(),"",FALSE,TRUE);
				m_NameList.AddTail(pValue);
			}
		}
	}
	else
	{
		InitNameList();
		for(int i=0; i<m_nCount; i++)
		{
			CXISLVar *pVar = new CXISLVar;
			pVar->SetAttribute("*","",FALSE,TRUE);
			m_NameList.AddTail(pVar);
		}
	}
	GetNameList(m_strNameList);

	m_lbVar.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);
	LVCOLUMNA column;
	column.mask = LVCF_TEXT|LVCF_WIDTH;

	RECT rect;
	m_lbVar.GetClientRect(&rect);
	column.cx = 50;
	column.pszText = "Scope";
	m_lbVar.InsertColumn(0,&column);

	column.cx = (rect.right-rect.left)-50;
	column.pszText = "ϐ";
	m_lbVar.InsertColumn(1,&column);

	int nType = m_pCurrentTag->m_nTagType;
	if(nType == ID_TAG_EXCHANGE || nType == ID_TAG_BEGIN || nType == ID_TAG_END)
	{
		int nCount = ((CXISLExcItem*)m_pCurrentTag)->m_pLocalVar->SetVar2ListBox(m_lbVar);
		
		CXISLDialogTag *pDTag = (CXISLDialogTag*)m_pCurrentTag->GetParentDialogTag();
		nCount = pDTag->m_pDialogVar->SetVar2ListBox(m_lbVar,nCount);
		
		CXISLRootTag *pRTag = (CXISLRootTag*)pDTag->GetRootTag();
		nCount = pRTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
		
		if(!pRTag->IsAppRoot() && g_pAppRootTag)
			g_pAppRootTag->m_pDocumentVar->SetVar2ListBox(m_lbVar,nCount);
	}
	else
		ASSERT(NULL);

	m_brEdit.CreateSolidBrush(RGB(255,255,255));

	UpdateData(FALSE);

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CXISLReturnDlg::OnDblclkListVar(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;

	_TCHAR szBuff[MAX_PATH];
	LVITEMA item;
	item.mask = LVIF_TEXT|LVIF_PARAM|LVIF_STATE;
	item.iItem = pNMListView->iItem;
	item.iSubItem = 0;
	item.pszText = szBuff;
	item.cchTextMax = sizeof(szBuff);
	item.stateMask = 0xFFFF;
	m_lbVar.GetItem(&item);

	if(item.iItem != -1)
	{
		CXISLVar *pVar = (CXISLVar*)item.lParam;

		if(m_nCount != 0)
		{
			ReplaceNLVar(pVar);
			GetNameList(m_strNameList);
		}

		UpdateData(FALSE);
	}
	*pResult = 0;
}

void CXISLReturnDlg::OnButtonChange() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	int nIndex;
	POSITION pos = m_lbVar.GetFirstSelectedItemPosition();
	if(pos == NULL)
		return;
	nIndex = m_lbVar.GetNextSelectedItem(pos);
	
	_TCHAR szBuff[MAX_PATH];
	LVITEMA item;
	item.mask = LVIF_TEXT|LVIF_PARAM|LVIF_STATE;
	item.iItem = nIndex;
	item.iSubItem = 0;
    item.pszText = szBuff;
    item.cchTextMax = sizeof(szBuff);
	item.stateMask = 0xFFFF;
	m_lbVar.GetItem(&item);

	CXISLVar *pVar = (CXISLVar*)item.lParam;
	CXISLChangeVarDlg CVarDlg(pVar);
	if(CVarDlg.DoModal() != IDOK)
		return;	
}

HBRUSH CXISLReturnDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	
	// TODO: ̈ʒu DC ̃Agr[gύXĂ
	switch(nCtlColor)
	{
	case CTLCOLOR_STATIC:
		if(pWnd->GetDlgCtrlID() == IDC_EDIT_NAMELIST)
		{
			pDC->SetBkMode(TRANSPARENT);	// wi
			pDC->SetTextColor(RGB(0,0,0));	// eLXgFݒ
			return (HBRUSH) m_brEdit;		// _~[uV
		}
			break;
	default:
		break;
	}
	
	// TODO: ftHg̃uV]݂̂̂łȂꍇɂ́AႤuVԂĂ
	return hbr;
}

BOOL CXISLReturnDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if( pMsg->message == WM_KEYDOWN )
	{
		CWnd *pWnd = GetFocus();
		CString strTemp;
		CXISLVar *pVar=NULL;
        switch( pMsg->wParam )
        {
        case VK_RETURN:   // Enter
			UpdateData();
			if(pWnd->GetDlgCtrlID() == IDC_EDIT_STRING)
			{
				strTemp = "'" + m_strString;
				strTemp += "'";
			}
			else if(pWnd->GetDlgCtrlID() == IDC_EDIT_VALUE)
			{
				strTemp.Format("%d",m_nValue);
			}
			pVar = new CXISLVar;
			pVar->SetAttribute(strTemp,"",FALSE,TRUE);
			ReplaceNLVar(pVar);
			GetNameList(m_strNameList);
			m_strString.Empty();
			m_nValue = 0;
			UpdateData(FALSE);
			return TRUE;
       default:
			break;
        }
	}
	else if(pMsg->message == WM_LBUTTONDOWN)
	{
		CDialog::PreTranslateMessage(pMsg);
		int nStart,nEnd;
		CWnd *pWnd = GetFocus();
		UpdateData();
		if(pWnd->GetDlgCtrlID() == IDC_EDIT_NAMELIST)
		{
			m_editNameList.GetSel(nStart,nEnd);
			nEnd = m_strNameList.Find(",",nStart);
			if(nEnd == -1)
				nEnd = m_strNameList.GetLength();
			if(nStart != 0)
			{
				nStart--;
				while(m_strNameList[nStart] != ',')
				{
					nStart--;
					if(nStart == -1)
						break;
				}
				nStart++;
			}
			m_editNameList.SetSel(nStart,nEnd);
		}
		return TRUE;
	}	
	return CDialog::PreTranslateMessage(pMsg);
}

void CXISLReturnDlg::GetNameList(CString &strName)
{
	POSITION pos = m_NameList.GetHeadPosition();
	CString strTemp;
	strName.Empty();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_NameList.GetNext(pos);
		pVar->GetVarNameEx(strTemp);
		strName += strTemp;
		strName += ",";
	}
	strName.Delete(strName.GetLength()-1);
}

int CXISLReturnDlg::GetSelectedNLVar()
{
	UpdateData();
	int nStart,nEnd;
	int nCount = 0;

	m_editNameList.GetSel(nStart,nEnd);

	nEnd = 0;
	while(1)
	{
		nEnd = m_strNameList.Find(",",nEnd);
		if(nEnd == -1 || nEnd >= nStart)
			break;
		nCount++;
		nEnd++;
	}
	return nCount;
}

void CXISLReturnDlg::ReplaceNLVar(CXISLVar *pVar)
{
	//IĂ̂ڂ̂̂
	int nIndex = GetSelectedNLVar();

	POSITION pos = m_NameList.FindIndex(nIndex);
	if(pos == NULL)
		ASSERT(NULL);
	CXISLVar *pSelectVar = (CXISLVar*)m_NameList.GetAt(pos);
	m_NameList.RemoveAt(pos);
	//ϐł͂ȂlȂ
	if(pSelectVar->IsDummy())
	{
		delete pSelectVar;
		pSelectVar = NULL;
	}
	pos = m_NameList.FindIndex(nIndex);
	if(pos)
		m_NameList.InsertBefore(pos,pVar);
	else
		m_NameList.AddTail(pVar);
}

void CXISLReturnDlg::InitNameList()
{
	POSITION oldPos = NULL;
	POSITION pos = m_NameList.GetHeadPosition();
	while(pos)
	{
		oldPos = pos;
		CXISLVar *pVar = (CXISLVar*)m_NameList.GetNext(pos);
		m_NameList.RemoveAt(oldPos);
		if(pVar->IsDummy())
			delete pVar;
	}
}
